# Debian: dokuwiki-plugins-extra

# Copyright (C) 2024-2025 Daniel Baumann <daniel@debian.org>
#
# SPDX-License-Identifier: GPL-3.0+
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Build-Depends:
# none

SHELL := sh -e

PLUGIN := dw2pdf

all:

test:

build:

install:
	mkdir -p $(DESTDIR)/usr/share/dokuwiki/plugins-extra
	cp -a $(PLUGIN) $(DESTDIR)/usr/share/dokuwiki/plugins-extra

	# removing unused files
	find $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN) -type f -name "README*" -exec rm -f {} +
	find $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN) -type f -name "LICENSE*" -exec rm -f {} +
	find $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN) -type f -name "*.txt" -exec rm -f {} +
	find $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN) -type f -name "*.md" -exec rm -f {} +

	find $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN) -name ".git*" -exec rm -rf {} +

	rm -rf $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)/_test

uninstall:
	rm -rf $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)
	rmdir --ignore-fail-on-non-empty --parents $(DESTDIR) || true

clean:

distclean:

reinstall: uninstall install

upstream:
	rm -rf $(PLUGIN)
	git clone https://github.com/splitbrain/dokuwiki-plugin-dw2pdf $(PLUGIN)
	rm -rf $(PLUGIN)/.git

	# dfsg
	rm -f $(PLUGIN)/vendor/mpdf/mpdf/data/iccprofiles/sRGB_IEC61966-2-1.icc
	rm -rf $(PLUGIN)/vendor/mpdf/mpdf/ttfonts
	ln -s /usr/share/fonts/truetype/dejavu $(PLUGIN)/vendor/mpdf/mpdf/ttfonts
