/**********************************************************************
 *
 * Copyright (c) 2004 Olaf Willuhn
 * All rights reserved.
 * 
 * This software is copyrighted work licensed under the terms of the
 * Jameica License.  Please consult the file "LICENSE" for details. 
 *
 **********************************************************************/

package de.willuhn.jameica.hbci.calendar;

import java.rmi.RemoteException;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;

/**
 * Implementierung eines Termin-Providers fuer offene SEPA-Lastschriften.
 */
public class SepaLastschriftAppointmentProvider extends AbstractAppointmentProvider<SepaLastschrift>
{
  @Override
  AbstractHibiscusAppointment createAppointment(Schedule<SepaLastschrift> schedule)
  {
    return new MyAppointment(schedule);
  }

  /**
   * Hilfsklasse zum Anzeigen und Oeffnen des Appointments.
   */
  private class MyAppointment extends AbstractHibiscusAppointment
  {
    /**
     * ct.
     * @param schedule der Auftrag.
     */
    private MyAppointment(Schedule<SepaLastschrift> schedule)
    {
      super(schedule);
    }

    @Override
    public String getDescription()
    {
      try
      {
        SepaLastschrift t = this.schedule.getContext();
        Konto k = t.getKonto();
        return i18n.tr("{0}SEPA-Lastschrift: {1} {2} von {3} einziehen\n\n{4}\n\nKonto: {5}",
                       (this.schedule.isPlanned() ? (i18n.tr("Geplant") + ":\n") : ""),
                       HBCI.DECIMALFORMAT.format(t.getBetrag()),
                       k.getWaehrung(),
                       t.getGegenkontoName(),
                       VerwendungszweckUtil.toString(t,"\n"),
                       k.getLongName());
      }
      catch (RemoteException re)
      {
        Logger.error("unable to build description",re);
        return null;
      }
    }

    @Override
    public String getName()
    {
      try
      {
        SepaLastschrift t = this.schedule.getContext();
        Konto k = t.getKonto();
        return i18n.tr("{0} {1} von {2}",HBCI.DECIMALFORMAT.format(t.getBetrag()),k.getWaehrung(),t.getGegenkontoName());
      }
      catch (RemoteException re)
      {
        Logger.error("unable to build name",re);
        return i18n.tr("SEPA-Lastschrift");
      }
    }
  }
}
