# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers.aio import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIContainerAppsPatchesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_patches_list_by_container_app(self, resource_group):
        response = self.client.container_apps_patches.list_by_container_app(
            resource_group_name=resource_group.name,
            container_app_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_patches_get(self, resource_group):
        response = await self.client.container_apps_patches.get(
            resource_group_name=resource_group.name,
            container_app_name="str",
            patch_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_patches_begin_delete(self, resource_group):
        response = await (
            await self.client.container_apps_patches.begin_delete(
                resource_group_name=resource_group.name,
                container_app_name="str",
                patch_name="str",
                api_version="2025-02-02-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_patches_begin_skip_configure(self, resource_group):
        response = await (
            await self.client.container_apps_patches.begin_skip_configure(
                resource_group_name=resource_group.name,
                container_app_name="str",
                patch_name="str",
                patch_skip_config={"skip": bool},
                api_version="2025-02-02-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_patches_begin_apply(self, resource_group):
        response = await (
            await self.client.container_apps_patches.begin_apply(
                resource_group_name=resource_group.name,
                container_app_name="str",
                patch_name="str",
                api_version="2025-02-02-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
