% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcEarthSunDist.R
\name{calcEarthSunDist}
\alias{calcEarthSunDist}
\title{Compute earth-sun distance based on day of the year}
\usage{
calcEarthSunDist(date, formula = c("Spencer", "Mather", "ESA", "Duffie"))
}
\arguments{
\item{date}{Date of the sensor overpass; either a character string in a 
native date format (e.g. "YYYY-MM-DD", see \code{\link{as.Date}}) or a POSIX* 
object (see \code{\link{as.POSIXct}}).}

\item{formula}{Formula to be applied, specified through the name of the 
author, i.e. one of "Spencer", "Mather", "ESA" or "Duffie" (see 'Details').}
}
\value{
Numeric earth-sun distance (in AU) or, if \code{formula = "Duffie"}, 
the relative squared earth--sun distance on the given day.
}
\description{
The earth-sun distance for a particular day of the year is computed based on
one of several empirical formulas.
}
\details{
Computation of earth-sun distance using formulas provided by
Spencer (1971), Mather (2005) or ESA. If \code{formula = "Duffie"}, the 
inverse squared relative earth--sun distance is returned as proposed by 
Duffie and Beckman (1980).
}
\examples{
calcEarthSunDist(date = "2015-01-01", formula = "Spencer") # absolute
calcEarthSunDist(date = "2015-01-01", formula = "Duffie")  # relative

}
\references{
The formulas are taken from the following sources:
\itemize{
  \item Spencer: Spencer JW (1971) Fourier series representation of the position of 
  the sun. Search 2/5. Taken from 
  \url{https://goo.gl/lhi9UI}. 

  \item Mather: Mather PM (2005) Computer Processing of Remotely-Sensed 
  Images: An Introduction. Wiley: Chichester, ISBN: 978-0-470-02101-9, 
  \url{https://www.wiley.com/en-us/Computer+Processing+of+Remotely-Sensed+Images\%3A+An+Introduction\%2C+3rd+Edition-p-9780470021019}.

  \item ESA: ESA Earth Observation Quality Control: Landsat frequently asked questions. 
  
  \item Duffie: Duffie JA, Beckman WA (2013) Solar Engineering of Thermal 
  Processes. Wiley: Hoboken, New Jersey, ISBN: 978-0-470-87366-3,
  \url{https://www.wiley.com/en-us/Solar+Engineering+of+Thermal+Processes\%2C+4th+Edition-p-9780470873663}.
}
See also: Bird R, Riordan C (1984) Simple solar spectral model for direct and 
diffuse irradiance on horizontal and tilted planes at the Earth's surface for
cloudless atmospheres. Task No. 3434.10, Solar Energy Research Institute: 
Golden, Colorado, \url{https://docs.nrel.gov/docs/legosti/old/2436.pdf}.
}
