# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
# Frame class definitions, used to generate FrameIdList.h and FrameTypeList.h

from FrameClass import DYNAMIC_LEAF, LEAF, NOT_LEAF, AbstractFrame, Frame

# See FrameClass.py and GenerateFrameLists.py for implementation details.
# The following is a list of all the frame classes, followed by the frame type,
# and whether they are a leaf.
#
# The frame type is somewhat arbitrary (could literally be anything) but for
# new frame class implementations it's probably a good idea to make it a unique
# string (maybe matching the frame name).
#
# See bug 1555477 for some related discussion about the whole Type() set-up.
FRAME_CLASSES = [
    Frame("BRFrame", "Br", LEAF),
    Frame("nsBCTableCellFrame", "TableCell", NOT_LEAF),
    Frame("nsBackdropFrame", "Backdrop", LEAF),
    Frame("nsBlockFrame", "Block", NOT_LEAF),
    Frame("nsCanvasFrame", "Canvas", NOT_LEAF),
    Frame("nsCheckboxRadioFrame", "CheckboxRadio", LEAF),
    Frame("nsColorControlFrame", "ColorControl", LEAF),
    Frame("nsColumnSetFrame", "ColumnSet", NOT_LEAF),
    Frame("ColumnSetWrapperFrame", "ColumnSetWrapper", NOT_LEAF),
    Frame("nsComboboxControlFrame", "ComboboxControl", NOT_LEAF),
    Frame("nsComboboxDisplayFrame", "ComboboxDisplay", NOT_LEAF),
    Frame("nsContinuingTextFrame", "Text", LEAF),
    Frame("nsDateTimeControlFrame", "DateTimeControl", NOT_LEAF),
    Frame("nsFieldSetFrame", "FieldSet", NOT_LEAF),
    Frame("nsFileControlFrame", "Block", LEAF),
    Frame("FileControlLabelFrame", "Block", NOT_LEAF),
    Frame("nsFirstLetterFrame", "Letter", NOT_LEAF),
    Frame("nsFirstLineFrame", "Line", NOT_LEAF),
    Frame("nsFlexContainerFrame", "FlexContainer", NOT_LEAF),
    Frame("nsIFrame", "None", NOT_LEAF),
    Frame("nsGfxButtonControlFrame", "GfxButtonControl", LEAF),
    Frame("nsGridContainerFrame", "GridContainer", NOT_LEAF),
    Frame("nsHTMLButtonControlFrame", "HTMLButtonControl", NOT_LEAF),
    Frame("nsHTMLCanvasFrame", "HTMLCanvas", NOT_LEAF),
    Frame("nsHTMLFramesetBlankFrame", "None", LEAF),
    Frame("nsHTMLFramesetBorderFrame", "None", LEAF),
    Frame("nsHTMLFramesetFrame", "FrameSet", LEAF),
    Frame("nsHTMLScrollFrame", "Scroll", NOT_LEAF),
    Frame("nsImageControlFrame", "ImageControl", LEAF),
    Frame("nsImageFrame", "Image", DYNAMIC_LEAF),
    Frame("nsInlineFrame", "Inline", NOT_LEAF),
    Frame("nsListControlFrame", "ListControl", NOT_LEAF),
    Frame("nsMathMLFrame", "None", NOT_LEAF),
    Frame("nsMathMLmactionFrame", "None", NOT_LEAF),
    Frame("nsMathMLmathBlockFrame", "Block", NOT_LEAF),
    Frame("nsMathMLmathInlineFrame", "Inline", NOT_LEAF),
    Frame("nsMathMLmencloseFrame", "None", NOT_LEAF),
    Frame("nsMathMLmfracFrame", "None", NOT_LEAF),
    Frame("nsMathMLmmultiscriptsFrame", "None", NOT_LEAF),
    Frame("nsMathMLmoFrame", "None", NOT_LEAF),
    Frame("nsMathMLmpaddedFrame", "None", NOT_LEAF),
    Frame("nsMathMLmrootFrame", "None", NOT_LEAF),
    Frame("nsMathMLmrowFrame", "None", NOT_LEAF),
    Frame("nsMathMLmspaceFrame", "None", LEAF),
    Frame("nsMathMLmsqrtFrame", "None", NOT_LEAF),
    Frame("nsMathMLmtableFrame", "Table", NOT_LEAF),
    Frame("nsMathMLmtableWrapperFrame", "TableWrapper", NOT_LEAF),
    Frame("nsMathMLmtdFrame", "TableCell", NOT_LEAF),
    Frame("nsMathMLmtdInnerFrame", "Block", NOT_LEAF),
    Frame("nsMathMLmtrFrame", "TableRow", NOT_LEAF),
    Frame("nsMathMLmunderoverFrame", "None", NOT_LEAF),
    Frame("nsMathMLsemanticsFrame", "None", NOT_LEAF),
    Frame("nsMathMLTokenFrame", "None", NOT_LEAF),
    Frame("nsMenuPopupFrame", "MenuPopup", NOT_LEAF),
    Frame("nsMeterFrame", "Meter", LEAF),
    Frame("nsNumberControlFrame", "TextInput", LEAF),
    Frame("nsPageBreakFrame", "PageBreak", LEAF),
    Frame("nsPageContentFrame", "PageContent", NOT_LEAF),
    Frame("nsPageFrame", "Page", NOT_LEAF),
    Frame("nsPlaceholderFrame", "Placeholder", LEAF),
    Frame("nsProgressFrame", "Progress", LEAF),
    Frame("nsRangeFrame", "Range", LEAF),
    Frame("nsRubyBaseContainerFrame", "RubyBaseContainer", NOT_LEAF),
    Frame("nsRubyBaseFrame", "RubyBase", NOT_LEAF),
    Frame("nsRubyFrame", "Ruby", NOT_LEAF),
    Frame("nsRubyTextContainerFrame", "RubyTextContainer", NOT_LEAF),
    Frame("nsRubyTextFrame", "RubyText", NOT_LEAF),
    Frame("SimpleXULLeafFrame", "SimpleXULLeaf", LEAF),
    Frame("nsScrollbarButtonFrame", "SimpleXULLeaf", LEAF),
    Frame("nsScrollbarFrame", "Scrollbar", NOT_LEAF),
    Frame("nsSearchControlFrame", "SearchControl", LEAF),
    Frame("nsSelectsAreaFrame", "Block", NOT_LEAF),
    Frame("nsPageSequenceFrame", "PageSequence", NOT_LEAF),
    Frame("nsSliderFrame", "Slider", NOT_LEAF),
    Frame("nsSplitterFrame", "SimpleXULLeaf", NOT_LEAF),
    Frame("nsSubDocumentFrame", "SubDocument", LEAF),
    Frame("PrintedSheetFrame", "PrintedSheet", NOT_LEAF),
    Frame("SVGAFrame", "SVGA", NOT_LEAF),
    Frame("SVGClipPathFrame", "SVGClipPath", NOT_LEAF),
    Frame("SVGContainerFrame", "None", NOT_LEAF),
    Frame("SVGFEContainerFrame", "SVGFEContainer", NOT_LEAF),
    Frame("SVGFEImageFrame", "SVGFEImage", LEAF),
    Frame("SVGFELeafFrame", "SVGFELeaf", LEAF),
    Frame("SVGFEUnstyledLeafFrame", "SVGFEUnstyledLeaf", LEAF),
    Frame("SVGFilterFrame", "SVGFilter", NOT_LEAF),
    Frame("SVGForeignObjectFrame", "SVGForeignObject", NOT_LEAF),
    Frame("SVGGenericContainerFrame", "SVGGenericContainer", NOT_LEAF),
    Frame("SVGGeometryFrame", "SVGGeometry", LEAF),
    Frame("SVGGFrame", "SVGG", NOT_LEAF),
    Frame("SVGImageFrame", "SVGImage", LEAF),
    Frame("SVGInnerSVGFrame", "SVGInnerSVG", NOT_LEAF),
    Frame("SVGLinearGradientFrame", "SVGLinearGradient", NOT_LEAF),
    Frame("SVGMarkerFrame", "SVGMarker", NOT_LEAF),
    Frame("SVGMarkerAnonChildFrame", "SVGMarkerAnonChild", NOT_LEAF),
    Frame("SVGMaskFrame", "SVGMask", NOT_LEAF),
    Frame("SVGOuterSVGFrame", "SVGOuterSVG", NOT_LEAF),
    Frame("SVGOuterSVGAnonChildFrame", "SVGOuterSVGAnonChild", NOT_LEAF),
    Frame("SVGPatternFrame", "SVGPattern", NOT_LEAF),
    Frame("SVGRadialGradientFrame", "SVGRadialGradient", NOT_LEAF),
    Frame("SVGStopFrame", "SVGStop", LEAF),
    Frame("SVGSwitchFrame", "SVGSwitch", NOT_LEAF),
    Frame("SVGSymbolFrame", "SVGSymbol", NOT_LEAF),
    Frame("SVGTextFrame", "SVGText", NOT_LEAF),
    # Not a leaf, though it always has a ShadowRoot, so in practice light DOM
    # children never render.
    Frame("SVGUseFrame", "SVGUse", NOT_LEAF),
    Frame("MiddleCroppingLabelFrame", "MiddleCroppingLabel", LEAF),
    Frame("SVGViewFrame", "SVGView", LEAF),
    Frame("nsTableCellFrame", "TableCell", NOT_LEAF),
    Frame("nsTableColFrame", "TableCol", LEAF),
    Frame("nsTableColGroupFrame", "TableColGroup", NOT_LEAF),
    Frame("nsTableFrame", "Table", NOT_LEAF),
    Frame("nsTableWrapperFrame", "TableWrapper", NOT_LEAF),
    Frame("nsTableRowFrame", "TableRow", NOT_LEAF),
    Frame("nsTableRowGroupFrame", "TableRowGroup", NOT_LEAF),
    Frame("nsTextControlFrame", "TextInput", LEAF),
    Frame("nsTextFrame", "Text", LEAF),
    Frame("nsTreeBodyFrame", "SimpleXULLeaf", LEAF),
    Frame("nsVideoFrame", "HTMLVideo", NOT_LEAF),
    Frame("ViewportFrame", "Viewport", NOT_LEAF),
    Frame("WBRFrame", "Wbr", LEAF),
    # Non-concrete classes (for FrameIID use)
    AbstractFrame("MiddleCroppingBlockFrame"),
    AbstractFrame("nsContainerFrame"),
    AbstractFrame("nsLeafFrame"),
    AbstractFrame("nsMathMLContainerFrame"),
    AbstractFrame("nsRubyContentFrame"),
    AbstractFrame("nsSplittableFrame"),
    AbstractFrame("SVGDisplayContainerFrame"),
    AbstractFrame("SVGGradientFrame"),
    AbstractFrame("SVGPaintServerFrame"),
    # Interfaces (for FrameIID use)
    AbstractFrame("nsIAnonymousContentCreator"),
    AbstractFrame("nsIFormControlFrame"),
    AbstractFrame("nsIMathMLFrame"),
    AbstractFrame("nsIPercentBSizeObserver"),
    AbstractFrame("nsIPopupContainer"),
    AbstractFrame("nsIScrollableFrame"),
    AbstractFrame("nsIScrollbarMediator"),
    AbstractFrame("nsISelectControlFrame"),
    AbstractFrame("nsIStatefulFrame"),
    AbstractFrame("ISVGDisplayableFrame"),
    AbstractFrame("ISVGSVGFrame"),
    AbstractFrame("nsITableCellLayout"),
    AbstractFrame("nsITableLayout"),
    AbstractFrame("nsITextControlFrame"),
]
