# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, Dict, IO, Iterable, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import KeyVaultClientConfiguration
from .._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from .._utils.serialization import Serializer
from .._utils.utils import ClientMixinABC

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_key_vault_get_certificates_request(
    *, maxresults: Optional[int] = None, include_pending: Optional[bool] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if include_pending is not None:
        _params["includePending"] = _SERIALIZER.query("include_pending", include_pending, "bool")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_delete_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_set_certificate_contacts_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/contacts"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_certificate_contacts_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/contacts"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_delete_certificate_contacts_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/contacts"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_certificate_issuers_request(  # pylint: disable=name-too-long
    *, maxresults: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/issuers"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_set_certificate_issuer_request(  # pylint: disable=name-too-long
    issuer_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/issuers/{issuer-name}"
    path_format_arguments = {
        "issuer-name": _SERIALIZER.url("issuer_name", issuer_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_update_certificate_issuer_request(  # pylint: disable=name-too-long
    issuer_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/issuers/{issuer-name}"
    path_format_arguments = {
        "issuer-name": _SERIALIZER.url("issuer_name", issuer_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_certificate_issuer_request(  # pylint: disable=name-too-long
    issuer_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/issuers/{issuer-name}"
    path_format_arguments = {
        "issuer-name": _SERIALIZER.url("issuer_name", issuer_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_delete_certificate_issuer_request(  # pylint: disable=name-too-long
    issuer_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/issuers/{issuer-name}"
    path_format_arguments = {
        "issuer-name": _SERIALIZER.url("issuer_name", issuer_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_create_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/create"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_import_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/import"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_certificate_versions_request(  # pylint: disable=name-too-long
    certificate_name: str, *, maxresults: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/versions"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_certificate_policy_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/policy"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_update_certificate_policy_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/policy"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_update_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, certificate_version: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/{certificate-version}"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
        "certificate-version": _SERIALIZER.url("certificate_version", certificate_version, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_certificate_request(
    certificate_name: str, certificate_version: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/{certificate-version}"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
        "certificate-version": _SERIALIZER.url("certificate_version", certificate_version, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_update_certificate_operation_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/pending"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_certificate_operation_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/pending"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_delete_certificate_operation_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/pending"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_merge_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/pending/merge"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_backup_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/{certificate-name}/backup"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_restore_certificate_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/certificates/restore"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_deleted_certificates_request(  # pylint: disable=name-too-long
    *, maxresults: Optional[int] = None, include_pending: Optional[bool] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/deletedcertificates"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if include_pending is not None:
        _params["includePending"] = _SERIALIZER.query("include_pending", include_pending, "bool")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_get_deleted_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/deletedcertificates/{certificate-name}"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_purge_deleted_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/deletedcertificates/{certificate-name}"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_key_vault_recover_deleted_certificate_request(  # pylint: disable=name-too-long
    certificate_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "7.6"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/deletedcertificates/{certificate-name}/recover"
    path_format_arguments = {
        "certificate-name": _SERIALIZER.url("certificate_name", certificate_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class KeyVaultClientOperationsMixin(  # pylint: disable=too-many-public-methods
    ClientMixinABC[PipelineClient[HttpRequest, HttpResponse], KeyVaultClientConfiguration]
):

    @distributed_trace
    def get_certificates(
        self, *, maxresults: Optional[int] = None, include_pending: Optional[bool] = None, **kwargs: Any
    ) -> Iterable["_models.CertificateItem"]:
        """List certificates in a specified key vault.

        The GetCertificates operation returns the set of certificates resources in the specified key
        vault. This operation requires the certificates/list permission.

        :keyword maxresults: Maximum number of results to return in a page. If not specified the
         service will return up to 25 results. Default value is None.
        :paramtype maxresults: int
        :keyword include_pending: Specifies whether to include certificates which are not completely
         provisioned. Default value is None.
        :paramtype include_pending: bool
        :return: An iterator like instance of CertificateItem
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.certificates._generated.models.CertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CertificateItem]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_key_vault_get_certificates_request(
                    maxresults=maxresults,
                    include_pending=include_pending,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.CertificateItem], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.KeyVaultError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_certificate(self, certificate_name: str, **kwargs: Any) -> _models.DeletedCertificateBundle:
        """Deletes a certificate from a specified key vault.

        Deletes all versions of a certificate object along with its associated policy. Delete
        certificate cannot be used to remove individual versions of a certificate object. This
        operation requires the certificates/delete permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :return: DeletedCertificateBundle. The DeletedCertificateBundle is compatible with
         MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.DeletedCertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DeletedCertificateBundle] = kwargs.pop("cls", None)

        _request = build_key_vault_delete_certificate_request(
            certificate_name=certificate_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DeletedCertificateBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def set_certificate_contacts(
        self, contacts: _models.Contacts, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param contacts: The contacts for the key vault certificate. Required.
        :type contacts: ~azure.keyvault.certificates._generated.models.Contacts
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Contacts. The Contacts is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def set_certificate_contacts(
        self, contacts: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param contacts: The contacts for the key vault certificate. Required.
        :type contacts: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Contacts. The Contacts is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def set_certificate_contacts(
        self, contacts: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param contacts: The contacts for the key vault certificate. Required.
        :type contacts: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Contacts. The Contacts is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def set_certificate_contacts(
        self, contacts: Union[_models.Contacts, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param contacts: The contacts for the key vault certificate. Is one of the following types:
         Contacts, JSON, IO[bytes] Required.
        :type contacts: ~azure.keyvault.certificates._generated.models.Contacts or JSON or IO[bytes]
        :return: Contacts. The Contacts is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Contacts] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(contacts, (IOBase, bytes)):
            _content = contacts
        else:
            _content = json.dumps(contacts, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_set_certificate_contacts_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Contacts, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_certificate_contacts(self, **kwargs: Any) -> _models.Contacts:
        """Lists the certificate contacts for a specified key vault.

        The GetCertificateContacts operation returns the set of certificate contact resources in the
        specified key vault. This operation requires the certificates/managecontacts permission.

        :return: Contacts. The Contacts is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Contacts] = kwargs.pop("cls", None)

        _request = build_key_vault_get_certificate_contacts_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Contacts, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_certificate_contacts(self, **kwargs: Any) -> _models.Contacts:
        """Deletes the certificate contacts for a specified key vault.

        Deletes the certificate contacts for a specified key vault certificate. This operation requires
        the certificates/managecontacts permission.

        :return: Contacts. The Contacts is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Contacts] = kwargs.pop("cls", None)

        _request = build_key_vault_delete_certificate_contacts_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Contacts, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_certificate_issuers(
        self, *, maxresults: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.CertificateIssuerItem"]:
        """List certificate issuers for a specified key vault.

        The GetCertificateIssuers operation returns the set of certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :keyword maxresults: Maximum number of results to return in a page. If not specified the
         service will return up to 25 results. Default value is None.
        :paramtype maxresults: int
        :return: An iterator like instance of CertificateIssuerItem
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.certificates._generated.models.CertificateIssuerItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CertificateIssuerItem]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_key_vault_get_certificate_issuers_request(
                    maxresults=maxresults,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.CertificateIssuerItem], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.KeyVaultError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @overload
    def set_certificate_issuer(
        self,
        issuer_name: str,
        parameter: _models.CertificateIssuerSetParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param issuer_name: The name of the issuer. The value you provide may be copied globally for
         the purpose of running the service. The value provided should not include personally
         identifiable or sensitive information. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Required.
        :type parameter: ~azure.keyvault.certificates._generated.models.CertificateIssuerSetParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def set_certificate_issuer(
        self, issuer_name: str, parameter: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param issuer_name: The name of the issuer. The value you provide may be copied globally for
         the purpose of running the service. The value provided should not include personally
         identifiable or sensitive information. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Required.
        :type parameter: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def set_certificate_issuer(
        self, issuer_name: str, parameter: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param issuer_name: The name of the issuer. The value you provide may be copied globally for
         the purpose of running the service. The value provided should not include personally
         identifiable or sensitive information. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Required.
        :type parameter: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def set_certificate_issuer(
        self, issuer_name: str, parameter: Union[_models.CertificateIssuerSetParameters, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param issuer_name: The name of the issuer. The value you provide may be copied globally for
         the purpose of running the service. The value provided should not include personally
         identifiable or sensitive information. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Is one of the following types:
         CertificateIssuerSetParameters, JSON, IO[bytes] Required.
        :type parameter: ~azure.keyvault.certificates._generated.models.CertificateIssuerSetParameters
         or JSON or IO[bytes]
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IssuerBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameter, (IOBase, bytes)):
            _content = parameter
        else:
            _content = json.dumps(parameter, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_set_certificate_issuer_request(
            issuer_name=issuer_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IssuerBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def update_certificate_issuer(
        self,
        issuer_name: str,
        parameter: _models.CertificateIssuerUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Required.
        :type parameter:
         ~azure.keyvault.certificates._generated.models.CertificateIssuerUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_issuer(
        self, issuer_name: str, parameter: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Required.
        :type parameter: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_issuer(
        self, issuer_name: str, parameter: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Required.
        :type parameter: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_certificate_issuer(
        self,
        issuer_name: str,
        parameter: Union[_models.CertificateIssuerUpdateParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Is one of the following types:
         CertificateIssuerUpdateParameters, JSON, IO[bytes] Required.
        :type parameter:
         ~azure.keyvault.certificates._generated.models.CertificateIssuerUpdateParameters or JSON or
         IO[bytes]
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IssuerBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameter, (IOBase, bytes)):
            _content = parameter
        else:
            _content = json.dumps(parameter, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_update_certificate_issuer_request(
            issuer_name=issuer_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IssuerBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_certificate_issuer(self, issuer_name: str, **kwargs: Any) -> _models.IssuerBundle:
        """Lists the specified certificate issuer.

        The GetCertificateIssuer operation returns the specified certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.IssuerBundle] = kwargs.pop("cls", None)

        _request = build_key_vault_get_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IssuerBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_certificate_issuer(self, issuer_name: str, **kwargs: Any) -> _models.IssuerBundle:
        """Deletes the specified certificate issuer.

        The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from
        the vault. This operation requires the certificates/manageissuers/deleteissuers permission.

        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :return: IssuerBundle. The IssuerBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.IssuerBundle] = kwargs.pop("cls", None)

        _request = build_key_vault_delete_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.IssuerBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def create_certificate(
        self,
        certificate_name: str,
        parameters: _models.CertificateCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param certificate_name: The name of the certificate. The value you provide may be copied
         globally for the purpose of running the service. The value provided should not include
         personally identifiable or sensitive information. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_certificate(
        self, certificate_name: str, parameters: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param certificate_name: The name of the certificate. The value you provide may be copied
         globally for the purpose of running the service. The value provided should not include
         personally identifiable or sensitive information. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_certificate(
        self, certificate_name: str, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param certificate_name: The name of the certificate. The value you provide may be copied
         globally for the purpose of running the service. The value provided should not include
         personally identifiable or sensitive information. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_certificate(
        self,
        certificate_name: str,
        parameters: Union[_models.CertificateCreateParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param certificate_name: The name of the certificate. The value you provide may be copied
         globally for the purpose of running the service. The value provided should not include
         personally identifiable or sensitive information. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Is one of the following types:
         CertificateCreateParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateCreateParameters or
         JSON or IO[bytes]
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateOperation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_create_certificate_request(
            certificate_name=certificate_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateOperation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def import_certificate(
        self,
        certificate_name: str,
        parameters: _models.CertificateImportParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. This
        operation requires the certificates/import permission. The certificate to be imported can be in
        either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key
        as well as x509 certificates. Key Vault will only accept a key in PKCS#8 format.

        :param certificate_name: The name of the certificate. The value you provide may be copied
         globally for the purpose of running the service. The value provided should not include
         personally identifiable or sensitive information. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateImportParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def import_certificate(
        self, certificate_name: str, parameters: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. This
        operation requires the certificates/import permission. The certificate to be imported can be in
        either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key
        as well as x509 certificates. Key Vault will only accept a key in PKCS#8 format.

        :param certificate_name: The name of the certificate. The value you provide may be copied
         globally for the purpose of running the service. The value provided should not include
         personally identifiable or sensitive information. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def import_certificate(
        self, certificate_name: str, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. This
        operation requires the certificates/import permission. The certificate to be imported can be in
        either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key
        as well as x509 certificates. Key Vault will only accept a key in PKCS#8 format.

        :param certificate_name: The name of the certificate. The value you provide may be copied
         globally for the purpose of running the service. The value provided should not include
         personally identifiable or sensitive information. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def import_certificate(
        self,
        certificate_name: str,
        parameters: Union[_models.CertificateImportParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. This
        operation requires the certificates/import permission. The certificate to be imported can be in
        either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key
        as well as x509 certificates. Key Vault will only accept a key in PKCS#8 format.

        :param certificate_name: The name of the certificate. The value you provide may be copied
         globally for the purpose of running the service. The value provided should not include
         personally identifiable or sensitive information. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Is one of the following types:
         CertificateImportParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateImportParameters or
         JSON or IO[bytes]
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_import_certificate_request(
            certificate_name=certificate_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_certificate_versions(
        self, certificate_name: str, *, maxresults: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.CertificateItem"]:
        """List the versions of a certificate.

        The GetCertificateVersions operation returns the versions of a certificate in the specified key
        vault. This operation requires the certificates/list permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword maxresults: Maximum number of results to return in a page. If not specified the
         service will return up to 25 results. Default value is None.
        :paramtype maxresults: int
        :return: An iterator like instance of CertificateItem
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.certificates._generated.models.CertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CertificateItem]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_key_vault_get_certificate_versions_request(
                    certificate_name=certificate_name,
                    maxresults=maxresults,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.CertificateItem], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.KeyVaultError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_certificate_policy(self, certificate_name: str, **kwargs: Any) -> _models.CertificatePolicy:
        """Lists the policy for a certificate.

        The GetCertificatePolicy operation returns the specified certificate policy resources in the
        specified key vault. This operation requires the certificates/get permission.

        :param certificate_name: The name of the certificate in a given key vault. Required.
        :type certificate_name: str
        :return: CertificatePolicy. The CertificatePolicy is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CertificatePolicy] = kwargs.pop("cls", None)

        _request = build_key_vault_get_certificate_policy_request(
            certificate_name=certificate_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificatePolicy, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def update_certificate_policy(
        self,
        certificate_name: str,
        certificate_policy: _models.CertificatePolicy,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Required.
        :type certificate_policy: ~azure.keyvault.certificates._generated.models.CertificatePolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificatePolicy. The CertificatePolicy is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_policy(
        self, certificate_name: str, certificate_policy: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Required.
        :type certificate_policy: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificatePolicy. The CertificatePolicy is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_policy(
        self,
        certificate_name: str,
        certificate_policy: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Required.
        :type certificate_policy: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificatePolicy. The CertificatePolicy is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_certificate_policy(
        self,
        certificate_name: str,
        certificate_policy: Union[_models.CertificatePolicy, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Is one of the following types:
         CertificatePolicy, JSON, IO[bytes] Required.
        :type certificate_policy: ~azure.keyvault.certificates._generated.models.CertificatePolicy or
         JSON or IO[bytes]
        :return: CertificatePolicy. The CertificatePolicy is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificatePolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(certificate_policy, (IOBase, bytes)):
            _content = certificate_policy
        else:
            _content = json.dumps(certificate_policy, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_update_certificate_policy_request(
            certificate_name=certificate_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificatePolicy, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def update_certificate(
        self,
        certificate_name: str,
        certificate_version: str,
        parameters: _models.CertificateUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate(
        self,
        certificate_name: str,
        certificate_version: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate(
        self,
        certificate_name: str,
        certificate_version: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_certificate(
        self,
        certificate_name: str,
        certificate_version: str,
        parameters: Union[_models.CertificateUpdateParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Is one of the following types:
         CertificateUpdateParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateUpdateParameters or
         JSON or IO[bytes]
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_update_certificate_request(
            certificate_name=certificate_name,
            certificate_version=certificate_version,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_certificate(
        self, certificate_name: str, certificate_version: str, **kwargs: Any
    ) -> _models.CertificateBundle:
        """Gets information about a certificate.

        Gets information about a specific certificate. This operation requires the certificates/get
        permission.

        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. This URI fragment is optional. If
         not specified, the latest version of the certificate is returned. Required.
        :type certificate_version: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        _request = build_key_vault_get_certificate_request(
            certificate_name=certificate_name,
            certificate_version=certificate_version,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def update_certificate_operation(
        self,
        certificate_name: str,
        certificate_operation: _models.CertificateOperationUpdateParameter,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Required.
        :type certificate_operation:
         ~azure.keyvault.certificates._generated.models.CertificateOperationUpdateParameter
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_operation(
        self,
        certificate_name: str,
        certificate_operation: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Required.
        :type certificate_operation: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_certificate_operation(
        self,
        certificate_name: str,
        certificate_operation: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Required.
        :type certificate_operation: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_certificate_operation(
        self,
        certificate_name: str,
        certificate_operation: Union[_models.CertificateOperationUpdateParameter, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Is one of the following
         types: CertificateOperationUpdateParameter, JSON, IO[bytes] Required.
        :type certificate_operation:
         ~azure.keyvault.certificates._generated.models.CertificateOperationUpdateParameter or JSON or
         IO[bytes]
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateOperation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(certificate_operation, (IOBase, bytes)):
            _content = certificate_operation
        else:
            _content = json.dumps(certificate_operation, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_update_certificate_operation_request(
            certificate_name=certificate_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateOperation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_certificate_operation(self, certificate_name: str, **kwargs: Any) -> _models.CertificateOperation:
        """Gets the creation operation of a certificate.

        Gets the creation operation associated with a specified certificate. This operation requires
        the certificates/get permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CertificateOperation] = kwargs.pop("cls", None)

        _request = build_key_vault_get_certificate_operation_request(
            certificate_name=certificate_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateOperation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_certificate_operation(self, certificate_name: str, **kwargs: Any) -> _models.CertificateOperation:
        """Deletes the creation operation for a specific certificate.

        Deletes the creation operation for a specified certificate that is in the process of being
        created. The certificate is no longer created. This operation requires the certificates/update
        permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :return: CertificateOperation. The CertificateOperation is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CertificateOperation] = kwargs.pop("cls", None)

        _request = build_key_vault_delete_certificate_operation_request(
            certificate_name=certificate_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateOperation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def merge_certificate(
        self,
        certificate_name: str,
        parameters: _models.CertificateMergeParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateMergeParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def merge_certificate(
        self, certificate_name: str, parameters: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def merge_certificate(
        self, certificate_name: str, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def merge_certificate(
        self,
        certificate_name: str,
        parameters: Union[_models.CertificateMergeParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Is one of the following types:
         CertificateMergeParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateMergeParameters or
         JSON or IO[bytes]
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_merge_certificate_request(
            certificate_name=certificate_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def backup_certificate(self, certificate_name: str, **kwargs: Any) -> _models.BackupCertificateResult:
        """Backs up the specified certificate.

        Requests that a backup of the specified certificate be downloaded to the client. All versions
        of the certificate will be downloaded. This operation requires the certificates/backup
        permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :return: BackupCertificateResult. The BackupCertificateResult is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.BackupCertificateResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BackupCertificateResult] = kwargs.pop("cls", None)

        _request = build_key_vault_backup_certificate_request(
            certificate_name=certificate_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BackupCertificateResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def restore_certificate(
        self, parameters: _models.CertificateRestoreParameters, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateBundle:
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param parameters: The parameters to restore the certificate. Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateRestoreParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def restore_certificate(
        self, parameters: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateBundle:
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param parameters: The parameters to restore the certificate. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def restore_certificate(
        self, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CertificateBundle:
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param parameters: The parameters to restore the certificate. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def restore_certificate(
        self, parameters: Union[_models.CertificateRestoreParameters, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CertificateBundle:
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param parameters: The parameters to restore the certificate. Is one of the following types:
         CertificateRestoreParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.keyvault.certificates._generated.models.CertificateRestoreParameters
         or JSON or IO[bytes]
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_key_vault_restore_certificate_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_deleted_certificates(
        self, *, maxresults: Optional[int] = None, include_pending: Optional[bool] = None, **kwargs: Any
    ) -> Iterable["_models.DeletedCertificateItem"]:
        """Lists the deleted certificates in the specified vault currently available for recovery.

        The GetDeletedCertificates operation retrieves the certificates in the current vault which are
        in a deleted state and ready for recovery or purging. This operation includes deletion-specific
        information. This operation requires the certificates/get/list permission. This operation can
        only be enabled on soft-delete enabled vaults.

        :keyword maxresults: Maximum number of results to return in a page. If not specified the
         service will return up to 25 results. Default value is None.
        :paramtype maxresults: int
        :keyword include_pending: Specifies whether to include certificates which are not completely
         provisioned. Default value is None.
        :paramtype include_pending: bool
        :return: An iterator like instance of DeletedCertificateItem
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.keyvault.certificates._generated.models.DeletedCertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.DeletedCertificateItem]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_key_vault_get_deleted_certificates_request(
                    maxresults=maxresults,
                    include_pending=include_pending,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url(
                        "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.DeletedCertificateItem], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.KeyVaultError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_deleted_certificate(self, certificate_name: str, **kwargs: Any) -> _models.DeletedCertificateBundle:
        """Retrieves information about the specified deleted certificate.

        The GetDeletedCertificate operation retrieves the deleted certificate information plus its
        attributes, such as retention interval, scheduled permanent deletion and the current deletion
        recovery level. This operation requires the certificates/get permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :return: DeletedCertificateBundle. The DeletedCertificateBundle is compatible with
         MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.DeletedCertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DeletedCertificateBundle] = kwargs.pop("cls", None)

        _request = build_key_vault_get_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DeletedCertificateBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def purge_deleted_certificate(  # pylint: disable=inconsistent-return-statements
        self, certificate_name: str, **kwargs: Any
    ) -> None:
        """Permanently deletes the specified deleted certificate.

        The PurgeDeletedCertificate operation performs an irreversible deletion of the specified
        certificate, without possibility for recovery. The operation is not available if the recovery
        level does not specify 'Purgeable'. This operation requires the certificate/purge permission.

        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_key_vault_purge_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def recover_deleted_certificate(self, certificate_name: str, **kwargs: Any) -> _models.CertificateBundle:
        """Recovers the deleted certificate back to its current version under /certificates.

        The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The
        operation is applicable in vaults enabled for soft-delete, and must be issued during the
        retention interval (available in the deleted certificate's attributes). This operation requires
        the certificates/recover permission.

        :param certificate_name: The name of the deleted certificate. Required.
        :type certificate_name: str
        :return: CertificateBundle. The CertificateBundle is compatible with MutableMapping
        :rtype: ~azure.keyvault.certificates._generated.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        _request = build_key_vault_recover_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url(
                "self._config.vault_base_url", self._config.vault_base_url, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.KeyVaultError, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CertificateBundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
