// generated by diplomat-tool
import { GeneralCategoryGroup } from "./GeneralCategoryGroup.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `GeneralCategory`](https://docs.rs/icu/latest/icu/properties/props/enum.GeneralCategory.html) for more information.
 */


export class GeneralCategory {
    #value = undefined;

    static #values = new Map([
        ["Unassigned", 0],
        ["UppercaseLetter", 1],
        ["LowercaseLetter", 2],
        ["TitlecaseLetter", 3],
        ["ModifierLetter", 4],
        ["OtherLetter", 5],
        ["NonspacingMark", 6],
        ["SpacingMark", 8],
        ["EnclosingMark", 7],
        ["DecimalNumber", 9],
        ["LetterNumber", 10],
        ["OtherNumber", 11],
        ["SpaceSeparator", 12],
        ["LineSeparator", 13],
        ["ParagraphSeparator", 14],
        ["Control", 15],
        ["Format", 16],
        ["PrivateUse", 17],
        ["Surrogate", 18],
        ["DashPunctuation", 19],
        ["OpenPunctuation", 20],
        ["ClosePunctuation", 21],
        ["ConnectorPunctuation", 22],
        ["InitialPunctuation", 28],
        ["FinalPunctuation", 29],
        ["OtherPunctuation", 23],
        ["MathSymbol", 24],
        ["CurrencySymbol", 25],
        ["ModifierSymbol", 26],
        ["OtherSymbol", 27]
    ]);

    static getAllEntries() {
        return GeneralCategory.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return GeneralCategory.#objectValues[arguments[1]];
        }

        if (value instanceof GeneralCategory) {
            return value;
        }

        let intVal = GeneralCategory.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return GeneralCategory.#objectValues[intVal];
        }

        throw TypeError(value + " is not a GeneralCategory and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new GeneralCategory(value);
    }

    get value(){
        for (let entry of GeneralCategory.#values) {
            if (entry[1] == this.#value) {
                return entry[0];
            }
        }
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = {
        [0]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        [1]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        [2]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        [3]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        [4]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        [5]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
        [6]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 6),
        [8]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 8),
        [7]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 7),
        [9]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 9),
        [10]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 10),
        [11]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 11),
        [12]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 12),
        [13]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 13),
        [14]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 14),
        [15]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 15),
        [16]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 16),
        [17]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 17),
        [18]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 18),
        [19]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 19),
        [20]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 20),
        [21]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 21),
        [22]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 22),
        [28]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 28),
        [29]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 29),
        [23]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 23),
        [24]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 24),
        [25]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 25),
        [26]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 26),
        [27]: new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 27),
    };

    static Unassigned = GeneralCategory.#objectValues[0];
    static UppercaseLetter = GeneralCategory.#objectValues[1];
    static LowercaseLetter = GeneralCategory.#objectValues[2];
    static TitlecaseLetter = GeneralCategory.#objectValues[3];
    static ModifierLetter = GeneralCategory.#objectValues[4];
    static OtherLetter = GeneralCategory.#objectValues[5];
    static NonspacingMark = GeneralCategory.#objectValues[6];
    static SpacingMark = GeneralCategory.#objectValues[8];
    static EnclosingMark = GeneralCategory.#objectValues[7];
    static DecimalNumber = GeneralCategory.#objectValues[9];
    static LetterNumber = GeneralCategory.#objectValues[10];
    static OtherNumber = GeneralCategory.#objectValues[11];
    static SpaceSeparator = GeneralCategory.#objectValues[12];
    static LineSeparator = GeneralCategory.#objectValues[13];
    static ParagraphSeparator = GeneralCategory.#objectValues[14];
    static Control = GeneralCategory.#objectValues[15];
    static Format = GeneralCategory.#objectValues[16];
    static PrivateUse = GeneralCategory.#objectValues[17];
    static Surrogate = GeneralCategory.#objectValues[18];
    static DashPunctuation = GeneralCategory.#objectValues[19];
    static OpenPunctuation = GeneralCategory.#objectValues[20];
    static ClosePunctuation = GeneralCategory.#objectValues[21];
    static ConnectorPunctuation = GeneralCategory.#objectValues[22];
    static InitialPunctuation = GeneralCategory.#objectValues[28];
    static FinalPunctuation = GeneralCategory.#objectValues[29];
    static OtherPunctuation = GeneralCategory.#objectValues[23];
    static MathSymbol = GeneralCategory.#objectValues[24];
    static CurrencySymbol = GeneralCategory.#objectValues[25];
    static ModifierSymbol = GeneralCategory.#objectValues[26];
    static OtherSymbol = GeneralCategory.#objectValues[27];


    /**
     * See the [Rust documentation for `for_char`](https://docs.rs/icu/latest/icu/properties/props/trait.EnumeratedProperty.html#tymethod.for_char) for more information.
     */
    static forChar(ch) {

        const result = wasm.icu4x_GeneralCategory_for_char_mv1(ch);

        try {
            return new GeneralCategory(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Convert to an integer using the ICU4C integer mappings for `General_Category`
     * Get the "long" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesLongBorrowed.html#method.get) for more information.
     */
    longName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_GeneralCategory_long_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Get the "short" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesShortBorrowed.html#method.get) for more information.
     */
    shortName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_GeneralCategory_short_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Convert to an integer value usable with ICU4C and CodePointMapData
     */
    toIntegerValue() {

        const result = wasm.icu4x_GeneralCategory_to_integer_value_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Produces a GeneralCategoryGroup mask that can represent a group of general categories
     *
     * See the [Rust documentation for `GeneralCategoryGroup`](https://docs.rs/icu/latest/icu/properties/props/struct.GeneralCategoryGroup.html) for more information.
     */
    toGroup() {

        const result = wasm.icu4x_GeneralCategory_to_group_mv1(this.ffiValue);

        try {
            return GeneralCategoryGroup._fromFFI(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Convert from an integer using the ICU4C integer mappings for `General_Category`
     * Convert from an integer value from ICU4C or CodePointMapData
     */
    static fromIntegerValue(other) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_GeneralCategory_from_integer_value_mv1(diplomatReceive.buffer, other);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new GeneralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}